//
//  ViewController.m
//  Displaying Progress with UIProgressView
//
//  Created by Vandad Nahavandipoor on 30/08/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController

@synthesize progressView;

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku

- (void)viewDidLoad{
  
  [super viewDidLoad];
  self.view.backgroundColor = [UIColor whiteColor];
  
  self.progressView = [[UIProgressView alloc] 
                       initWithProgressViewStyle:UIProgressViewStyleBar];
  self.progressView.center = self.view.center;
  
  self.progressView.progress = 20.0f / 30.0f;
  
  [self.view addSubview:self.progressView];

}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.progressView = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
  [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
  [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
  // Zwrot wartości YES dla obsługiwanych układów.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
  } else {
    return YES;
  }
}

@end
